#ifndef _HANDSHAKE_CPP
#define _HANDSHAKE_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"
#include "../../SharedClasses/CRC32/CRC.H"

#include "../SockServer/SockServer.H"

#include "NSWFL.H"
#include "Init.H"
#include "Entry.H"
#include "Routines.H"
#include "HandShake.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void BinPrint(const char *sData, int iLen)
{
	int iRPos = 0;
	while(iRPos < iLen)
	{
		printf("%X\n", sData[iRPos]);
		iRPos++;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	int PerformHandShake(int iClient, char *sRecvBuf, int iRecvBufSz)

	Performs a hand shake. Also know as Client/Server Authentication.

	Possible return Values:
		AUTH_FAILED   //The authentication process failed.
		AUTH_SUCCESS  //The authentication process was a success.
		AUTH_OK       //The authentication process is still in process, all is well.
		AUTH_ERROR    //The authentication process failed due to an error.
*/
int PerformHandShake(SocketServer *pSockSrvr, int iClient, char *sCmdBuf, int iCmdBufSz)
{
    char sCmdData[RECEIVEBUFSZ + 1];
    char sSendBuf[MAXSENDBUFSZ + 1];
    char sTemp[MAXSENDBUFSZ + 1];

	int iCmdDataSz = 0;
	int iSendBufSz = 0;
	int iCmdFlagLength = 0;

	if((iCmdFlagLength = CmdCmp(sCmdBuf, "::RequestAuthString")))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Server requested authentication.");

		int iTempLen = strlen(gsAuthString);

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);
		CCI.MyCrypt.Encode(gsAuthString, sTemp, iTempLen);
		iSendBufSz = AppendDataToCmd("::AuthString->", sTemp, iTempLen, sSendBuf);
		pSockSrvr->SetNextSendDataEx(iClient, sSendBuf, iSendBufSz);
		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::NewAuthKey->")))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Server issued new cryptography key.");

		int iTempLen = strlen(gsAuthString);

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		CCI.MyCrypt.Decode(sCmdData, sCmdData, iCmdDataSz);
		sCmdData[iCmdDataSz] = '\0';
		CCI.MyCrypt.UninitializeCryptographySet();
		memset(&CCI.MyCrypt, 0, sizeof(CCI.MyCrypt));

		if(!CCI.MyCrypt.InitializeCryptographySet(sCmdData, iCmdDataSz, CRYPTFLAGS))
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Failed to Initialize the cryptography set.");
		}

		CCI.MyCrypt.Encode(gsAuthString, sTemp, iTempLen);

		iSendBufSz = AppendDataToCmd("::NewKeyAuth->", sTemp, iTempLen, sSendBuf);

		pSockSrvr->SetNextSendDataEx(iClient, sSendBuf, iSendBufSz);
		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::RequestVersion")))
    {
		int iTempLen = strlen(gsFileVersion);

		CCI.MyCrypt.Encode(gsFileVersion, sTemp, iTempLen);
		iSendBufSz = AppendDataToCmd("::Version->", sTemp, iTempLen, sSendBuf);
		pSockSrvr->SetNextSendDataEx(iClient, sSendBuf, iSendBufSz);
		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::RequestCompanyName")))
    {
		int iTempLen = strlen(gsCompanyName);

		CCI.MyCrypt.Encode(gsCompanyName, sTemp, iTempLen);
		iSendBufSz = AppendDataToCmd("::CompanyName->", sTemp, iTempLen, sSendBuf);
		pSockSrvr->SetNextSendDataEx(iClient, sSendBuf, iSendBufSz);
		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::RequestPassword")))
    {
		int iTempLen = strlen(gsPassword);

		CCI.MyCrypt.Encode(gsPassword, sTemp, iTempLen);
		iSendBufSz = AppendDataToCmd("::Password->", sTemp, iTempLen, sSendBuf);
		pSockSrvr->SetNextSendDataEx(iClient, sSendBuf, iSendBufSz);
		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::AuthenticationSuccess")))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Authentication success.");
		return AUTH_SUCCESS;
	}

	return AUTH_ERROR;	
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
